/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowMapPane;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class VWProcessEditMenu
extends VWPopupMenu
implements ActionListener,
ItemListener,
IVWToolbarActionListener,
IVWPropertyChangeListener {
    private JMenu m_newMenu = null;
    private JMenuItem m_newGeneralStepMenuItem = null;
    private JMenuItem m_newCallStepMenuItem = null;
    private JMenuItem m_newSystemStepMenuItem = null;
    private JMenuItem m_newComponentStepMenuItem = null;
    private JMenuItem m_newTextAnnotationMenuItem = null;
    private JMenuItem m_cutItem = null;
    private JMenuItem m_copyItem = null;
    private JMenuItem m_pasteItem = null;
    private JMenuItem m_deleteItem = null;
    private JMenuItem m_addToStepPaletteItem = null;
    private JMenu m_changeStepTypeMenu = null;
    private ButtonGroup m_changeStepTypeMenuGroup = null;
    private JRadioButtonMenuItem m_changeGeneralStepTypeItem = null;
    private JRadioButtonMenuItem m_changeCallStepTypeItem = null;
    private JRadioButtonMenuItem m_changeSystemStepTypeItem = null;
    private JRadioButtonMenuItem m_changeComponentStepTypeItem = null;
    private JMenu m_changeTextAnnotationColorMenu = null;
    private ButtonGroup m_changeAnnotationColorMenuGroup = null;
    private JRadioButtonMenuItem m_blueColorMenuItem = null;
    private JRadioButtonMenuItem m_grayColorMenuItem = null;
    private JRadioButtonMenuItem m_greenColorMenuItem = null;
    private JRadioButtonMenuItem m_pinkColorMenuItem = null;
    private JRadioButtonMenuItem m_yellowColorMenuItem = null;
    private IVWProcessCanvasPanel m_processCanvasPanel = null;
    private VWDesignerCoreData m_designerCoreData = null;

    public VWProcessEditMenu(IVWProcessCanvasPanel processCanvasPanel) {
        this.m_processCanvasPanel = processCanvasPanel;
        this.m_designerCoreData = this.m_processCanvasPanel.getAuthPropertyData().getDesignerCoreData();
        this.createMenuItems(this);
        this.m_processCanvasPanel.getWorkflowPane().addItemListener(this);
        this.m_processCanvasPanel.getAuthPropertyData().getToolbarActionNotifier().addToolbarActionListener(this);
        this.m_processCanvasPanel.getAuthPropertyData().getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public void initializeMenu(JMenu editMenu) {
        this.createMenuItems(editMenu);
    }

    public void releaseReferences() {
        int nIndex;
        Component[] items;
        this.m_processCanvasPanel.getWorkflowPane().removeItemListener(this);
        this.m_processCanvasPanel.getAuthPropertyData().getToolbarActionNotifier().removeToolbarActionListener(this);
        this.m_processCanvasPanel.getAuthPropertyData().getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_newMenu != null) {
            items = this.m_newMenu.getMenuComponents();
            if (items != null) {
                for (nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_newMenu.removeAll();
            this.m_newMenu = null;
        }
        this.m_newGeneralStepMenuItem = null;
        this.m_newCallStepMenuItem = null;
        this.m_newSystemStepMenuItem = null;
        this.m_newComponentStepMenuItem = null;
        this.m_newTextAnnotationMenuItem = null;
        if (this.m_cutItem != null) {
            this.m_cutItem.removeActionListener(this);
            this.m_cutItem = null;
        }
        if (this.m_copyItem != null) {
            this.m_copyItem.removeActionListener(this);
            this.m_copyItem = null;
        }
        if (this.m_pasteItem != null) {
            this.m_pasteItem.removeActionListener(this);
            this.m_pasteItem = null;
        }
        if (this.m_deleteItem != null) {
            this.m_deleteItem.removeActionListener(this);
            this.m_deleteItem = null;
        }
        if (this.m_addToStepPaletteItem != null) {
            this.m_addToStepPaletteItem.removeActionListener(this);
            this.m_addToStepPaletteItem = null;
        }
        if (this.m_changeStepTypeMenu != null) {
            items = this.m_changeStepTypeMenu.getMenuComponents();
            if (items != null) {
                for (nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_changeStepTypeMenu.removeAll();
            this.m_changeStepTypeMenu = null;
        }
        this.m_changeStepTypeMenuGroup = null;
        this.m_changeGeneralStepTypeItem = null;
        this.m_changeCallStepTypeItem = null;
        this.m_changeSystemStepTypeItem = null;
        this.m_changeComponentStepTypeItem = null;
        if (this.m_changeTextAnnotationColorMenu != null) {
            items = this.m_changeTextAnnotationColorMenu.getMenuComponents();
            if (items != null) {
                for (nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_changeTextAnnotationColorMenu.removeAll();
            this.m_changeTextAnnotationColorMenu = null;
        }
        this.m_changeAnnotationColorMenuGroup = null;
        this.m_blueColorMenuItem = null;
        this.m_grayColorMenuItem = null;
        this.m_greenColorMenuItem = null;
        this.m_pinkColorMenuItem = null;
        this.m_yellowColorMenuItem = null;
        this.m_processCanvasPanel = null;
        this.m_designerCoreData = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_newGeneralStepMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).createNewStep(7, VWDesignerWorkflowMapPane.DEFAULT_STEP_LOCATION);
        } else if (source == this.m_newCallStepMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).createNewStep(9, VWDesignerWorkflowMapPane.DEFAULT_STEP_LOCATION);
        } else if (source == this.m_newSystemStepMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).createNewStep(11, VWDesignerWorkflowMapPane.DEFAULT_STEP_LOCATION);
        } else if (source == this.m_newComponentStepMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).createNewStep(13, VWDesignerWorkflowMapPane.DEFAULT_STEP_LOCATION);
        } else if (source == this.m_newTextAnnotationMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).createNewTextAnnotation(VWDesignerWorkflowMapPane.DEFAULT_TEXT_ANNOTATION_LOCATION);
        } else if (source == this.m_cutItem) {
            this.m_processCanvasPanel.getWorkflowPane().copySelectedItems(true);
            this.performChangeMapAction();
        } else if (source == this.m_copyItem) {
            this.m_processCanvasPanel.getWorkflowPane().copySelectedItems(false);
            this.performChangeMapAction();
        } else if (source == this.m_pasteItem) {
            this.m_processCanvasPanel.getWorkflowPane().pasteCopiedItems(null);
        } else if (source == this.m_deleteItem) {
            this.m_processCanvasPanel.getWorkflowPane().deleteSelectedItems();
        } else if (source == this.m_addToStepPaletteItem) {
            this.m_processCanvasPanel.getWorkflowPane().addSelectedStepsToStepPalette();
        } else if (source == this.m_changeGeneralStepTypeItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeStepType(7);
        } else if (source == this.m_changeCallStepTypeItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeStepType(9);
        } else if (source == this.m_changeSystemStepTypeItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeStepType(11);
        } else if (source == this.m_changeComponentStepTypeItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeStepType(13);
        } else if (source == this.m_blueColorMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeTextAnnotationColor(VWColorListCellRenderer.COLOR_BLUE);
        } else if (source == this.m_grayColorMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeTextAnnotationColor(VWColorListCellRenderer.COLOR_GRAY);
        } else if (source == this.m_greenColorMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeTextAnnotationColor(VWColorListCellRenderer.COLOR_GREEN);
        } else if (source == this.m_pinkColorMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeTextAnnotationColor(VWColorListCellRenderer.COLOR_PINK);
        } else if (source == this.m_yellowColorMenuItem) {
            ((VWDesignerWorkflowMapPane)this.m_processCanvasPanel.getWorkflowPane().getActiveMapPane()).changeTextAnnotationColor(VWColorListCellRenderer.COLOR_YELLOW);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object src = event.getSource();
        VWDesignerWorkflowPane workflowPane = this.m_processCanvasPanel.getWorkflowPane();
        if (workflowPane != null && src == workflowPane.getActiveMapPane()) {
            switch (event.getStateChange()) {
                case 1: {
                    this.performSelectObjectAction();
                    break;
                }
                case 2: {
                    this.performDeselectObjectAction();
                }
            }
            return;
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 500: {
                this.performCreateMapAction();
                break;
            }
            case 501: {
                this.performDeleteMapAction(null);
                break;
            }
            case 502: {
                this.performChangeMapAction();
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block6: {
            try {
                Object object = event.getSource();
                if (!(object instanceof IVWPropertyChangeSource) || object == this) break block6;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)object;
                block1 : switch (event.getID()) {
                    case 572: {
                        Vector items = source.getItemsChanged();
                        for (int nIndex = 0; nIndex < items.size(); ++nIndex) {
                            object = items.elementAt(nIndex);
                            if (object == null || !(object instanceof VWTextAnnotationDefinition)) continue;
                            this.updateSelectedColor((VWTextAnnotationDefinition)object);
                            break block1;
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    private void createMenuItems(JComponent parentMenu) {
        this.createNewMenu(parentMenu);
        parentMenu.add(new JSeparator());
        int nMenuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.m_cutItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuCut_withHK);
        if (this.m_cutItem != null) {
            this.m_cutItem.setAccelerator(KeyStroke.getKeyStroke(88, nMenuShortcutKeyMask));
            this.m_cutItem.addActionListener(this);
            this.m_cutItem.setEnabled(false);
            parentMenu.add(this.m_cutItem);
        }
        this.m_copyItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuCopy_withHK);
        if (this.m_copyItem != null) {
            this.m_copyItem.setAccelerator(KeyStroke.getKeyStroke(67, nMenuShortcutKeyMask));
            this.m_copyItem.addActionListener(this);
            this.m_copyItem.setEnabled(false);
            parentMenu.add(this.m_copyItem);
        }
        this.m_pasteItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuPaste_withHK);
        if (this.m_pasteItem != null) {
            this.m_pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, nMenuShortcutKeyMask));
            this.m_pasteItem.addActionListener(this);
            this.m_pasteItem.setEnabled(false);
            parentMenu.add(this.m_pasteItem);
        }
        this.m_deleteItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuDelete_withHK);
        if (this.m_deleteItem != null) {
            this.m_deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, nMenuShortcutKeyMask));
            this.m_deleteItem.addActionListener(this);
            this.m_deleteItem.setEnabled(false);
            parentMenu.add(this.m_deleteItem);
        }
        if (this.m_designerCoreData.getApplicationMode() == 1) {
            this.m_addToStepPaletteItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuAddToStepPalette_withHK);
            if (this.m_addToStepPaletteItem != null) {
                parentMenu.add(new JSeparator());
                this.m_addToStepPaletteItem.addActionListener(this);
                this.m_addToStepPaletteItem.setEnabled(false);
                parentMenu.add(this.m_addToStepPaletteItem);
            }
        }
        this.createChangeStepTypeMenu(parentMenu);
        this.createChangeAnnotationColorMenu(parentMenu);
    }

    private void createNewMenu(JComponent parentMenu) {
        this.m_newMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuNew_withHK);
        if (this.m_newMenu != null) {
            parentMenu.add(this.m_newMenu);
            this.m_newGeneralStepMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuGeneralStep_withHK);
            if (this.m_newGeneralStepMenuItem != null) {
                this.m_newGeneralStepMenuItem.addActionListener(this);
                this.m_newMenu.add(this.m_newGeneralStepMenuItem);
            }
            this.m_newCallStepMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSubmapStep_withHK);
            if (this.m_newCallStepMenuItem != null) {
                this.m_newCallStepMenuItem.addActionListener(this);
                this.m_newMenu.add(this.m_newCallStepMenuItem);
            }
            if (this.m_designerCoreData.getApplicationMode() == 1) {
                this.m_newSystemStepMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuSystemStep_withHK);
                if (this.m_newSystemStepMenuItem != null) {
                    this.m_newSystemStepMenuItem.addActionListener(this);
                    this.m_newMenu.add(this.m_newSystemStepMenuItem);
                }
                this.m_newComponentStepMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuComponentStep_withHK);
                if (this.m_newComponentStepMenuItem != null) {
                    this.m_newComponentStepMenuItem.addActionListener(this);
                    this.m_newMenu.add(this.m_newComponentStepMenuItem);
                }
            }
            this.m_newMenu.add(new JSeparator());
            this.m_newTextAnnotationMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_menuTextAnnotation_withHK);
            if (this.m_newTextAnnotationMenuItem != null) {
                this.m_newTextAnnotationMenuItem.addActionListener(this);
                this.m_newMenu.add(this.m_newTextAnnotationMenuItem);
            }
        }
    }

    private void createChangeStepTypeMenu(JComponent parentMenu) {
        this.m_changeStepTypeMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuChangeStepType_withHK);
        if (this.m_changeStepTypeMenu != null) {
            parentMenu.add(new JSeparator());
            parentMenu.add(this.m_changeStepTypeMenu);
            this.m_changeStepTypeMenuGroup = new ButtonGroup();
            this.m_changeGeneralStepTypeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuGeneralStep_withHK);
            if (this.m_changeGeneralStepTypeItem != null) {
                this.m_changeGeneralStepTypeItem.addActionListener(this);
                this.m_changeGeneralStepTypeItem.setSelected(true);
                this.m_changeStepTypeMenu.add(this.m_changeGeneralStepTypeItem);
                this.m_changeStepTypeMenuGroup.add(this.m_changeGeneralStepTypeItem);
            }
            this.m_changeCallStepTypeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuSubmapStep_withHK);
            if (this.m_changeCallStepTypeItem != null) {
                this.m_changeCallStepTypeItem.addActionListener(this);
                this.m_changeStepTypeMenu.add(this.m_changeCallStepTypeItem);
                this.m_changeStepTypeMenuGroup.add(this.m_changeCallStepTypeItem);
            }
            if (this.m_designerCoreData.getApplicationMode() == 1) {
                this.m_changeSystemStepTypeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuSystemStep_withHK);
                if (this.m_changeSystemStepTypeItem != null) {
                    this.m_changeSystemStepTypeItem.addActionListener(this);
                    this.m_changeStepTypeMenu.add(this.m_changeSystemStepTypeItem);
                    this.m_changeStepTypeMenuGroup.add(this.m_changeSystemStepTypeItem);
                }
                this.m_changeComponentStepTypeItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuComponentStep_withHK);
                if (this.m_changeComponentStepTypeItem != null) {
                    this.m_changeComponentStepTypeItem.addActionListener(this);
                    this.m_changeStepTypeMenu.add(this.m_changeComponentStepTypeItem);
                    this.m_changeStepTypeMenuGroup.add(this.m_changeComponentStepTypeItem);
                }
            }
            this.m_changeStepTypeMenu.setEnabled(false);
        }
    }

    private void createChangeAnnotationColorMenu(JComponent parentMenu) {
        this.m_changeTextAnnotationColorMenu = VWStringUtils.getMenuUsingString(VWResource.s_menuChangeTextAnnotationColor_withHK);
        if (this.m_changeTextAnnotationColorMenu != null) {
            parentMenu.add(this.m_changeTextAnnotationColorMenu);
            this.m_changeAnnotationColorMenuGroup = new ButtonGroup();
            this.m_blueColorMenuItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuBlue_withHK);
            if (this.m_blueColorMenuItem != null) {
                this.m_blueColorMenuItem.addActionListener(this);
                this.m_changeAnnotationColorMenuGroup.add(this.m_blueColorMenuItem);
                this.m_changeTextAnnotationColorMenu.add(this.m_blueColorMenuItem);
            }
            this.m_grayColorMenuItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuGray_withHK);
            if (this.m_blueColorMenuItem != null) {
                this.m_grayColorMenuItem.addActionListener(this);
                this.m_changeAnnotationColorMenuGroup.add(this.m_grayColorMenuItem);
                this.m_changeTextAnnotationColorMenu.add(this.m_grayColorMenuItem);
            }
            this.m_greenColorMenuItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuGreen_withHK);
            if (this.m_blueColorMenuItem != null) {
                this.m_greenColorMenuItem.addActionListener(this);
                this.m_changeAnnotationColorMenuGroup.add(this.m_greenColorMenuItem);
                this.m_changeTextAnnotationColorMenu.add(this.m_greenColorMenuItem);
            }
            this.m_pinkColorMenuItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuPink_withHK);
            if (this.m_blueColorMenuItem != null) {
                this.m_pinkColorMenuItem.addActionListener(this);
                this.m_changeAnnotationColorMenuGroup.add(this.m_pinkColorMenuItem);
                this.m_changeTextAnnotationColorMenu.add(this.m_pinkColorMenuItem);
            }
            this.m_yellowColorMenuItem = VWStringUtils.getRadioButtonMenuItemUsingString(VWResource.s_menuYellow_withHK);
            if (this.m_blueColorMenuItem != null) {
                this.m_yellowColorMenuItem.addActionListener(this);
                this.m_changeAnnotationColorMenuGroup.add(this.m_yellowColorMenuItem);
                this.m_changeTextAnnotationColorMenu.add(this.m_yellowColorMenuItem);
            }
        }
    }

    private void performCreateMapAction() {
        if (this.m_processCanvasPanel.getWorkflowPane() != null) {
            this.m_processCanvasPanel.getWorkflowPane().newMap();
        }
    }

    private void performDeleteMapAction(String mapName) {
        if (this.m_processCanvasPanel.getWorkflowPane() != null) {
            this.m_processCanvasPanel.getWorkflowPane().deleteMap(mapName);
        }
    }

    private void performChangeMapAction() {
        boolean bIsEditable = false;
        if (this.m_processCanvasPanel != null) {
            bIsEditable = this.m_processCanvasPanel.getAuthPropertyData().isCurrentMapEditable();
        }
        if (this.m_newMenu != null) {
            this.m_newMenu.setEnabled(bIsEditable);
        }
        this.m_pasteItem.setEnabled(bIsEditable && this.m_designerCoreData.getHasItemsInClipboard());
    }

    private void performDeselectObjectAction() {
        boolean bIsEditable = false;
        if (this.m_processCanvasPanel != null) {
            bIsEditable = this.m_processCanvasPanel.getAuthPropertyData().isCurrentMapEditable();
        }
        this.m_cutItem.setEnabled(false);
        this.m_copyItem.setEnabled(false);
        this.m_pasteItem.setEnabled(bIsEditable && this.m_designerCoreData.getHasItemsInClipboard());
        this.m_deleteItem.setEnabled(false);
        if (this.m_addToStepPaletteItem != null) {
            this.m_addToStepPaletteItem.setEnabled(false);
        }
        if (this.m_changeStepTypeMenu != null) {
            this.m_changeStepTypeMenu.setEnabled(false);
        }
        if (this.m_changeTextAnnotationColorMenu != null) {
            this.m_changeTextAnnotationColorMenu.setEnabled(false);
        }
    }

    private void performSelectObjectAction() {
        boolean bEnableCut = false;
        boolean bEnableCopy = false;
        boolean bEnableDelete = false;
        boolean bEnableStepPaletteBuffer = false;
        boolean bEnableChangeStepType = false;
        boolean bEnableTextAnnotationColorMenu = false;
        boolean bLaunchStep = false;
        Object[] objArray = null;
        VWDesignerWorkflowPane workflowPane = this.m_processCanvasPanel.getWorkflowPane();
        if (workflowPane != null) {
            objArray = workflowPane.getSelectedObjects();
        }
        if (objArray != null) {
            bEnableCut = true;
            bEnableCopy = true;
            bEnableDelete = true;
            bEnableStepPaletteBuffer = true;
            bEnableChangeStepType = true;
            int nArrayLength = objArray.length;
            if (nArrayLength > 0) {
                if (nArrayLength == 1) {
                    if (objArray[0] instanceof VWMapNode) {
                        switch (VWStepUtils.getStepType((VWMapNode)objArray[0])) {
                            case 0: {
                                bEnableCut = false;
                                bEnableCopy = false;
                                bEnableDelete = false;
                                bEnableStepPaletteBuffer = false;
                                bEnableChangeStepType = false;
                                break;
                            }
                            case 2: 
                            case 4: 
                            case 6: 
                            case 10: 
                            case 12: 
                            case 14: {
                                bEnableCut = false;
                                bEnableDelete = false;
                            }
                        }
                    } else if (objArray[0] instanceof VWTextAnnotationDefinition) {
                        bEnableStepPaletteBuffer = false;
                        bEnableChangeStepType = false;
                        bEnableTextAnnotationColorMenu = true;
                        this.updateSelectedColor((VWTextAnnotationDefinition)objArray[0]);
                    } else {
                        bEnableCut = false;
                        bEnableCopy = false;
                        bEnableStepPaletteBuffer = false;
                        bEnableChangeStepType = false;
                    }
                }
                for (int i = 0; i < nArrayLength; ++i) {
                    if (objArray[i] instanceof VWMapNode) {
                        switch (VWStepUtils.getStepType((VWMapNode)objArray[i])) {
                            case 0: {
                                bEnableChangeStepType = false;
                                bLaunchStep = true;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                this.m_changeGeneralStepTypeItem.removeActionListener(this);
                                this.m_changeGeneralStepTypeItem.setSelected(true);
                                this.m_changeGeneralStepTypeItem.addActionListener(this);
                                break;
                            }
                            case 9: 
                            case 10: {
                                this.m_changeCallStepTypeItem.removeActionListener(this);
                                this.m_changeCallStepTypeItem.setSelected(true);
                                this.m_changeCallStepTypeItem.addActionListener(this);
                                break;
                            }
                            case 11: 
                            case 12: {
                                if (this.m_changeSystemStepTypeItem == null) break;
                                this.m_changeSystemStepTypeItem.removeActionListener(this);
                                this.m_changeSystemStepTypeItem.setSelected(true);
                                this.m_changeSystemStepTypeItem.addActionListener(this);
                                break;
                            }
                            case 13: 
                            case 14: {
                                if (this.m_changeComponentStepTypeItem == null) break;
                                this.m_changeComponentStepTypeItem.removeActionListener(this);
                                this.m_changeComponentStepTypeItem.setSelected(true);
                                this.m_changeComponentStepTypeItem.addActionListener(this);
                            }
                        }
                    } else if (objArray[i] instanceof VWTextAnnotationDefinition && !bEnableTextAnnotationColorMenu) {
                        bEnableTextAnnotationColorMenu = true;
                        this.updateSelectedColor((VWTextAnnotationDefinition)objArray[i]);
                    }
                    if (bLaunchStep) break;
                }
            }
        }
        boolean bIsEditable = false;
        if (this.m_processCanvasPanel != null) {
            bIsEditable = this.m_processCanvasPanel.getAuthPropertyData().isCurrentMapEditable();
        }
        this.m_cutItem.setEnabled(bEnableCut && bIsEditable);
        this.m_copyItem.setEnabled(bEnableCopy);
        this.m_pasteItem.setEnabled(bIsEditable && this.m_designerCoreData.getHasItemsInClipboard());
        this.m_deleteItem.setEnabled(bEnableDelete && bIsEditable);
        if (this.m_addToStepPaletteItem != null) {
            this.m_addToStepPaletteItem.setEnabled(!bLaunchStep && bEnableStepPaletteBuffer);
        }
        if (this.m_changeStepTypeMenu != null) {
            this.m_changeStepTypeMenu.setEnabled(bEnableChangeStepType && bIsEditable);
        }
        if (this.m_changeTextAnnotationColorMenu != null) {
            this.m_changeTextAnnotationColorMenu.setEnabled(bEnableTextAnnotationColorMenu && bIsEditable);
        }
    }

    private void updateSelectedColor(VWTextAnnotationDefinition textAnnoDef) {
        Color bgColor;
        if (textAnnoDef != null && (bgColor = textAnnoDef.getBgColor()) != null) {
            if (bgColor.equals(VWColorListCellRenderer.COLOR_BLUE)) {
                this.m_blueColorMenuItem.setSelected(true);
            }
            if (bgColor.equals(VWColorListCellRenderer.COLOR_GRAY)) {
                this.m_grayColorMenuItem.setSelected(true);
            }
            if (bgColor.equals(VWColorListCellRenderer.COLOR_GREEN)) {
                this.m_greenColorMenuItem.setSelected(true);
            }
            if (bgColor.equals(VWColorListCellRenderer.COLOR_PINK)) {
                this.m_pinkColorMenuItem.setSelected(true);
            }
            if (bgColor.equals(VWColorListCellRenderer.COLOR_YELLOW)) {
                this.m_yellowColorMenuItem.setSelected(true);
            }
        }
    }
}

